/**
 * \file: mspin_udp_helper.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * mySPIN UDP Helper Functions
 *
 * \component: MSPIN
 *
 * \author: Thilo Bjoern Fickel BSOT/PJ-ES1 thilo.fickel@bosch-softtec.com
 *
 * \copyright: (c) 2018 Bosch SoftTec GmbH
 *
 * \history
 * 0.1 TFickel Initial version
 *
 ***********************************************************************/

#ifndef MSPIN_UDP_HELPER_H_
#define MSPIN_UDP_HELPER_H_

#include "mspin_typedef.h"
#include "mspin_appl_if_adapter.h"
#include <netdb.h>          //getaddrinfo, in_addr_t

#define MSPIN_UDP_PACKET_MAX_LENGTH 1024

void mspin_udp_freeBTName(mspin_udp_MessageParameter_t *pMessage);

MSPIN_ERROR mspin_udp_validateMessageParameters(MSPIN_UDP_MESSAGE_PARAMETER_t *pMessageParameters);

MSPIN_ERROR mspin_udp_copyMessageParameters(MSPIN_UDP_MESSAGE_PARAMETER_t *pSourceMessage, mspin_udp_MessageParameter_t *pDestMessage);

MSPIN_ERROR mspin_udp_createUDPMessage(mspin_udp_MessageParameter_t *pMessage, char* udpMessage, unsigned int length,
                                       const char* hostString);

MSPIN_ERROR mspin_udp_getBroadcastAddress(const U8 *interface, in_addr_t *pIPAddr, in_addr_t *pNetmask);

#endif /* MSPIN_UDP_HELPER_H_ */
